%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  to analyze FRAP data:
%
%   1) normalize for background
%   2) normalize for prebleach or plateau
%   3) fit with with exponential curve A(1-exp(-r*t))
%
%   Input:  select folder that contains txt files with data in columns;
%   first row titles, first column time, second column bleach area, third
%   column extracellular background, forth column whole cell
% 
%   Elisa Dultz September 2014
%   18.4.2019: changed data import to import new csv format put out by
%   Leica software
%   2019: added possibility to have multiple frapped regions in same movie.
%   Column order then needs to be FRAP1, FRAP2, ..., 
%   wholecell1, wholecell2, ..., background
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function FRAP_Results = analyzeFRAPcsv_fit_%%%%%%%%DATA_v201120()

% set parameters
prebleachN = 10; % number of prebleach images
startfit = 11; % number of image at which fit is started (after bleaching)
bleachcorr = 0; % set to 1 if bleachcorrection desired;
endfit = 200;
multiple_frapped_regions = 0;
roino_bleached = 2;
roino_bg = 4;
roino_wholecell = 3;
%% read in files
% get folder with files
datadir = uigetdir('Select Folder with data files');
% get list of .txt files
myfiles = dir(fullfile(datadir,'*.csv'));

%% read in files
ncount=0;
for i=1:size(myfiles,1)
    %D(i,1)=importdata(fullfile(datadir, myfiles(i,1).name));
    fid = fopen(fullfile(datadir, myfiles(i,1).name), 'rt', 'n', 'UTF16LE');
    fread(fid, 10, '*uint8');   %adjust the 2 to fit the UTF encoding
    filecontent = fread(fid, [1 inf], '*char');
    fclose(fid);
    datacell = textscan(filecontent, '%s%f%f%f%f%f%f%f%f%f%f%f%f', 'Delimiter', ',', 'HeaderLines', 2);
    datacell{1,1}=str2double(datacell{1,1});
    datacell{1,1}=cat(1,datacell{1,1});
    % if several cells where fRAP in the same movie, then the region order
    % needs to be FRAP1, FRAP2, ... , wholecell1, wholecell2,..., BG; here
    % they will be sorted out into separate positions
    
    % find out how many positions there are
    if multiple_frapped_regions ==1
    roinum = 0;
    for r=1:size(datacell,2)
        if ~isnan(datacell{1,r}(1,1))
            roinum=roinum+1;
        end 
    end
    posnum = (roinum-2)/2;
    else
    posnum = 1;
    end
    for n=1:posnum
        ncount = ncount+1;
        clear datacell_n
        datacell_n{1,1} = datacell{1,1};
        datacell_n{1,2} = datacell{1,n+1};
        datacell_n{1,3} = datacell{1,n+2};
        datacell_n{1,4} = datacell{1,n+3}; 
        datacell_n{1,5} = datacell{1,n+4};
        for k=1:5
         D(ncount,1).data(:,k)=datacell_n{1,k};
        end
        D(ncount,1).file = myfiles(i,1).name;
        D(ncount,1).directory = datadir;
    end

end
%%


%% normalize data and fit
for i=1:size(D,1)

   % subtract background
   D(i,1).Bg_subtracted = D(i,1).data(:,roino_bleached+1)-D(i,1).data(:,roino_bg+1);
   D(i,1).whole_cell_Bg_subtracted = D(i,1).data(:,roino_wholecell+1)-D(i,1).data(:,roino_bg+1);

   % bleach correction (optional) by whole cell fluorescence
   if bleachcorr == 1
      D(i,1).Corr = D(i,1).Bg_subtracted./D(i,1).whole_cell_Bg_subtracted;
     %subtract first postbleach
      D(i,1).norm1 =  D(i,1).Corr (:,1)- D(i,1).Corr(startfit,1);
      % normalize for prebleach    
      D(i,1).NormCorr = D(i,1).norm1./nanmean(D(i,1).norm1(1:prebleachN));
      figure(1); plot(D(i,1).data(:,1)-D(i,1).data(startfit,1),(D(i,1).NormCorr));
      hold on;
      fitdata = D(i,1).NormCorr;
   
   else
       %subtract first postbleach
       D(i,1).norm1 =  D(i,1).Bg_subtracted(:,1)- D(i,1).Bg_subtracted(startfit,1);
       D(i,1).Norm = D(i,1).norm1./nanmean(D(i,1).norm1(1:prebleachN));
       figure(1); plot(D(i,1).data(:,1)-D(i,1).data(startfit,1),(D(i,1).Norm));
       hold on;
       fitdata = D(i,1).Norm;
   end
    
       
   
   %% fit with exponential curve A(1-exp(-r*t))
    [fitresult, gof] = createFit(D(i,1).data((startfit:endfit),1)-D(i,1).data(startfit,1),fitdata(startfit:endfit));
    coeffs(1:2,i) = coeffvalues(fitresult); 
    coeffs(3,i)=gof.rsquare;
    title([D(i,1).file(1:end-4) '_' num2str(i)]);
    text(2,0,['R2=' num2str(gof.rsquare)]);
    hold off;
    savefig(fullfile(datadir,['Figure' D(i,1).file(1:end-4)]));
    
    
   
   
 %%   
    coeffs(4,i)= -log(0.5)/coeffs(2,i); %half-time of recovery
    D(i,1).coeffs = coeffs(:,i);
    display(['Just processed ' D(i,1).file '. Press any button to continue.'])
    if i<size(D,1)
    waitforbuttonpress;
    end
end

FRAP_Results=coeffs;
%%
figure(2); boxplot(FRAP_Results(4,:)');ylim([0 2]);
figure(2); text(1,1,['Mean t1/2 =' num2str(nanmean(FRAP_Results(4,:)))]);
save(fullfile(datadir,'FRAP_Results'),'FRAP_Results');
save(fullfile(datadir,'All_Curves'),'D');
end
